unit uPrincipal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TContador = record
    Valor : Integer;
  end;
  PCONTADOR = ^TContador;


  TFrmAplicacao = class(TForm)
    btnCriarArquivo: TButton;
    btnAtualizarVisao: TButton;
    edtContador: TEdit;
    lblContador: TLabel;
    btnIncrementarContador: TButton;
    procedure btnCriarArquivoClick(Sender: TObject);
    procedure btnAtualizarVisaoClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnIncrementarContadorClick(Sender: TObject);
  private
    { Private declarations }
    FHandleArquivo : THandle;
    FContador : PCONTADOR;

    procedure AtualizarContador;
  public
    { Public declarations }
  end;

var
  FrmAplicacao: TFrmAplicacao;

implementation

{$R *.DFM}


procedure TFrmAplicacao.btnCriarArquivoClick(Sender: TObject);
begin
  FHandleArquivo := CreateFileMapping($FFFFFFFF,
                                      nil,
                                      PAGE_READWRITE,
                                      0,
                                      SizeOf(TContador),
                                      'MeuArquivo');
  if FHandleArquivo <> 0 then
  begin
    FContador := MapViewOfFile(FHandleArquivo, FILE_MAP_WRITE, 0, 0, 0);
    FContador^.Valor := 1;
    AtualizarContador;
  end
  else
    ShowMessage('Erro ao criar arquivo!');
end;

procedure TFrmAplicacao.AtualizarContador;
begin
  edtContador.Text := IntToStr(FContador^.Valor);
end;

procedure TFrmAplicacao.btnAtualizarVisaoClick(Sender: TObject);
begin
  AtualizarContador;
end;

procedure TFrmAplicacao.FormDestroy(Sender: TObject);
begin
  UnmapViewOfFile(FContador);
  CloseHandle(FhandleArquivo);
end;

procedure TFrmAplicacao.btnIncrementarContadorClick(Sender: TObject);
begin
  Inc(FContador.Valor);
  AtualizarContador;
end;

end.
